/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keyvalue;

import io.privacyresearch.clientdata.keyvalue.AbstractStorage;
import io.privacyresearch.clientdata.keyvalue.KeyValueData;
import io.privacyresearch.clientdata.keyvalue.UsernameLink;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;

public class AccountStorage
extends AbstractStorage {
    private static final Logger LOG = Logger.getLogger(AccountStorage.class.getName());
    private static final String COLLECTION = "account";
    final String KEY_E164 = "account.e164";
    final String KEY_ACI = "account.aci";
    final String KEY_PNI = "account.pni";
    final String KEY_DEVICE_ID = "account.device_id";
    final String KEY_DEVICE_NAME = "account.device_name";
    final String KEY_SERVICE_PASSWORD = "account.service_password";
    final String KEY_REGISTRATION_ID = "account.registration_id";
    final String KEY_PNI_REGISTRATION_ID = "account.pni_registration_id";
    final String KEY_ACI_IDENTITY_PUBLIC_KEY = "account.aci_identity_public_key";
    final String KEY_ACI_IDENTITY_PRIVATE_KEY = "account.aci_identity_private_key";
    final String KEY_PNI_IDENTITY_PUBLIC_KEY = "account.pni_identity_public_key";
    final String KEY_PNI_IDENTITY_PRIVATE_KEY = "account.pni_identity_private_key";
    final String KEY_USERNAME = "account.username";
    final String KEY_USERNAME_LINK_ENTROPY = "account.username_link_entropy";
    final String KEY_USERNAME_LINK_SERVER_ID = "account.username_link_server_id";
    final String KEY_USERNAME_QR_CODE_COLOR = "account.username_qr_code_color";
    final String KEY_MASTER_KEY = "account.master_key";

    public AccountStorage(KeyValueData keyValueData) {
        super(keyValueData, COLLECTION);
    }

    public void storeAccountRecord(SignalAccountRecord sar) {
        AccountRecord.UsernameLink ulink;
        if (sar.getUsername() != null) {
            this.setUsername(sar.getUsername());
        }
        if ((ulink = sar.getUsernameLink()) != null && ulink.getEntropy().size() > 0) {
            try {
                this.setUsernameLinkEntropy(ulink.getEntropy().toByteArray());
                this.setUsernameLinkServerId(ulink.getServerId().toByteArray());
                this.setUsernameLinkColor(ulink.getColor().getNumber());
                LOG.info("Storing link with link " + this.getLink() + " and color = " + ulink.getColor().getNumber());
            }
            catch (Throwable t) {
                LOG.warning("Unexpected exception trying to parse usernamelink. ");
                LOG.warning("entropy = " + String.valueOf(ulink.getEntropy()));
                LOG.warning("serverbytes = " + String.valueOf(ulink.getServerId()));
                LOG.warning("color = " + String.valueOf(ulink.getColor()));
            }
        }
    }

    public IdentityKeyPair getAciIdentityKey() {
        return this.getIdentityKeyPair(this.getAciIdentityPrivateKey(), this.getAciIdentityPublicKey());
    }

    public IdentityKeyPair getPniIdentityKey() {
        return this.getIdentityKeyPair(this.getPniIdentityPrivateKey(), this.getPniIdentityPublicKey());
    }

    public UsernameLink getUsernameLink() {
        byte[] entropy = this.getUsernameLinkEntropy();
        byte[] serverId = this.getUsernameLinkServerId();
        if (entropy == null || serverId == null) {
            return null;
        }
        int color = this.getUsernameLinkColor();
        return new UsernameLink(entropy, serverId, color);
    }

    public ServiceId.ACI getAci() {
        return ServiceId.ACI.parseOrNull((String)this.getString("account.aci"));
    }

    public void setAci(ServiceId.ACI aci) {
        this.putString("account.aci", aci.toString());
    }

    public ServiceId.ACI requireAci() {
        return ServiceId.ACI.parseOrThrow((String)this.getString("account.aci"));
    }

    public ServiceId.PNI getPni() {
        return ServiceId.PNI.parseOrNull((String)this.getString("account.pni"));
    }

    public void setPni(ServiceId.PNI pni) {
        this.putString("account.pni", pni.toString());
    }

    public String getE164() {
        return this.getString("account.e164");
    }

    public void setE164(String e164) {
        this.putString("account.e164", e164);
    }

    public String getServicePassword() {
        return this.getString("account.service_password");
    }

    public void setServicePassword(String servicePassword) {
        this.putString("account.service_password", servicePassword);
    }

    public int getDeviceId() {
        String deviceId = this.getString("account.device_id", "-1");
        return Integer.parseInt(deviceId);
    }

    public void setDeviceId(int did) {
        this.putString("account.device_id", Integer.toString(did));
    }

    public String getDeviceName() {
        return this.getString("account.device_name");
    }

    public void setDeviceName(String v) {
        this.putString("account.device_name", v);
    }

    public String getRegistrationId() {
        return this.getString("account.registration_id");
    }

    public void setRegistrationId(String regId) {
        this.putString("account.registration_id", regId);
    }

    public String getPniRegistrationId() {
        return this.getString("account.pni_registration_id");
    }

    public void setPniRegistrationId(String regId) {
        this.putString("account.pni_registration_id", regId);
    }

    public void setAciIdentityPublicKey(byte[] key) {
        this.setValue("account.aci_identity_public_key", key);
    }

    public byte[] getAciIdentityPublicKey() {
        return this.getValue("account.aci_identity_public_key");
    }

    public void setAciIdentityPrivateKey(byte[] key) {
        this.setValue("account.aci_identity_private_key", key);
    }

    public byte[] getAciIdentityPrivateKey() {
        return this.getValue("account.aci_identity_private_key");
    }

    public void setPniIdentityPublicKey(byte[] key) {
        this.setValue("account.pni_identity_public_key", key);
    }

    public byte[] getPniIdentityPublicKey() {
        return this.getValue("account.pni_identity_public_key");
    }

    public void setPniIdentityPrivateKey(byte[] key) {
        this.setValue("account.pni_identity_private_key", key);
    }

    public byte[] getPniIdentityPrivateKey() {
        return this.getValue("account.pni_identity_private_key");
    }

    public void setUsername(String v) {
        this.putString("account.username", v);
    }

    public String getUsername() {
        return this.getString("account.username");
    }

    public void setUsernameLinkEntropy(byte[] v) {
        this.setValue("account.username_link_entropy", v);
    }

    public void setUsernameLinkColor(int v) {
        this.putString("account.username_qr_code_color", Integer.toString(v));
    }

    public int getUsernameLinkColor() {
        String color = this.getString("account.username_qr_code_color", "-1");
        return Integer.parseInt(color);
    }

    public byte[] getUsernameLinkEntropy() {
        return this.getValue("account.username_link_entropy");
    }

    public void setUsernameLinkServerId(byte[] v) {
        this.setValue("account.username_link_server_id", v);
    }

    public byte[] getUsernameLinkServerId() {
        return this.getValue("account.username_link_server_id");
    }

    public void setMasterKey(byte[] key) {
        this.setValue("account.master_key", key);
    }

    public byte[] getMasterKey() {
        return this.getValue("account.master_key");
    }

    @Override
    public String getString(String key, String defaultValue) {
        byte[] raw = this.getValue(key);
        if (raw == null) {
            return defaultValue;
        }
        return new String(raw, Charset.defaultCharset());
    }

    @Override
    public void putString(String key, String val) {
        this.setValue(key, val.getBytes(Charset.defaultCharset()));
    }

    IdentityKeyPair getIdentityKeyPair(byte[] privateBytes, byte[] publicBytes) {
        try {
            if (privateBytes == null || publicBytes == null) {
                return null;
            }
            ECPrivateKey privateKey = Curve.decodePrivatePoint((byte[])privateBytes);
            ECPublicKey publicKey = new ECPublicKey(publicBytes);
            ECKeyPair keyPair = new ECKeyPair(publicKey, privateKey);
            IdentityKey identityKey = new IdentityKey(publicKey);
            IdentityKeyPair ikp = new IdentityKeyPair(identityKey, privateKey);
            return ikp;
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private String getLink() {
        byte[] buffer = new byte[48];
        System.arraycopy(this.getUsernameLinkEntropy(), 0, buffer, 0, 32);
        System.arraycopy(this.getUsernameLinkServerId(), 0, buffer, 32, 16);
        return Base64.getEncoder().encodeToString(buffer);
    }
}

