/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keyvalue;

import io.privacyresearch.clientdata.keyvalue.KeyValue;
import io.privacyresearch.clientdata.keyvalue.KeyValueData;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractStorage {
    private static final Logger LOG = Logger.getLogger(AbstractStorage.class.getName());
    private final KeyValueData keyValueData;
    private final String collection;

    public AbstractStorage(KeyValueData keyValueData, String collection) {
        this.keyValueData = keyValueData;
        this.collection = collection;
    }

    protected String getString(String key) {
        return this.getString(key, null);
    }

    protected String getString(String key, String defaultValue) {
        byte[] raw = this.getValue(key);
        if (raw == null) {
            return defaultValue;
        }
        return new String(raw, Charset.defaultCharset());
    }

    protected void putString(String key, String val) {
        this.setValue(key, val.getBytes(Charset.defaultCharset()));
    }

    public byte[] getValue(String key) {
        try {
            List<KeyValue> kvs = this.keyValueData.findByKeyAndCollection(key, this.collection);
            if (kvs == null) {
                LOG.severe("GetValue for " + key + " returns a null list.");
                throw new IllegalArgumentException();
            }
            if (kvs.size() != 1) {
                LOG.warning("instead of 1 entry for " + key + ", we got " + kvs.size() + ". Return null");
            }
            KeyValue kv = kvs.size() == 1 ? kvs.get(0) : null;
            return kv != null ? kv.getValue() : null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setValue(String key, byte[] val) {
        try {
            KeyValue kv = new KeyValue(key, this.collection, val);
            this.keyValueData.add(kv);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

