/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.whispersystems.signalservice.api.push.ServiceId;

public class KyberPreKeyData
extends BaseData<KyberPreKeyRecord> {
    private static final Logger LOG = Logger.getLogger(KyberPreKeyData.class.getName());
    public static final String TABLE_NAME = "kyber_prekey";

    public KyberPreKeyData(Connection connection) {
        super(connection, TABLE_NAME, List.of(Fields.values()));
    }

    @Override
    public KyberPreKeyRecord construct(ResultSet resultSet) throws SQLException {
        byte[] ser = (byte[])Fields.SERIALIZED.getValue(resultSet);
        try {
            return new KyberPreKeyRecord(ser);
        }
        catch (InvalidMessageException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void add(ServiceId serviceId, int id, KyberPreKeyRecord record, boolean lastResort) {
        LOG.info("Add a Kyberprekey for serviceid " + serviceId.toString() + " and id = " + id);
        if (id != record.getId()) {
            throw new IllegalArgumentException("KeyId does not match id");
        }
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ACCOUNT_ID, serviceId.toString()), Map.entry(Fields.KEY_ID, id), Map.entry(Fields.TIMESTAMP, record.getTimestamp()), Map.entry(Fields.SERIALIZED, record.serialize()), Map.entry(Fields.LAST_RESORT, lastResort));
        try {
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public KyberPreKeyRecord findById(ServiceId serviceId, int id) {
        try {
            KyberPreKeyRecord answer = (KyberPreKeyRecord)super.findById(id);
            LOG.info("Got kyberpkr: " + String.valueOf(answer) + " should have id = " + id);
            LOG.info("ID = " + answer.getId());
            return answer;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<KyberPreKeyRecord> findAllByServiceId(ServiceId serviceId) {
        LinkedList<KyberPreKeyRecord> answer = new LinkedList<KyberPreKeyRecord>();
        try {
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toString()))).execute();
            while (result.next()) {
                answer.add(this.construct(result));
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        return answer;
    }

    public void deleteIfNotLastResort(ServiceId serviceId, int kyberPreKeyId) {
        try {
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toString()), new DatabaseLayer.BinaryOperandField(Fields.KEY_ID, kyberPreKeyId), new DatabaseLayer.BinaryOperandField(Fields.LAST_RESORT, false))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void deleteAllStaleBefore(ServiceId serviceId, long threshold, int minCount) {
        Object[] formatArgs = new Object[]{Fields.ACCOUNT_ID.getColumnName(), Fields.LAST_RESORT.getColumnName(), Fields.STALE_TIMESTAMP.getColumnName(), Fields.STALE_TIMESTAMP.getColumnName(), threshold, Fields.KEY_ID.getColumnName(), Fields.KEY_ID.getColumnName(), this.getTableName(), Fields.ACCOUNT_ID.getColumnName(), Fields.LAST_RESORT.getColumnName(), Fields.STALE_TIMESTAMP.getColumnName(), Fields.STALE_TIMESTAMP.getColumnName(), Fields.KEY_ID.getColumnName(), minCount};
        String where = String.format("    %s = ?\n    AND %s = 0\n    AND %s > 0\n    AND %s < %d\n    AND %s NOT IN (\n        SELECT %s\n        FROM %s\n        WHERE %s = ? AND %s = 0\n        ORDER BY\n            CASE %s WHEN 0 THEN 1 ELSE 0 END DESC,\n            %s DESC,\n            %s DESC\n        LIMIT %d\n    )\n", formatArgs);
        try {
            this.databaseLayer.delete(this.getTableName()).where(where, pstmt -> {
                pstmt.setString(1, serviceId.toString());
                pstmt.setString(2, serviceId.toString());
            }).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<KyberPreKeyRecord> getAllLastResort(ServiceId serviceId) {
        LinkedList<KyberPreKeyRecord> answer = new LinkedList<KyberPreKeyRecord>();
        try {
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toString()), new DatabaseLayer.BinaryOperandField(Fields.LAST_RESORT, true))).execute();
            while (result.next()) {
                answer.add(this.construct(result));
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        return answer;
    }

    public void delete(ServiceId serviceId, int kyberPreKeyId) {
        try {
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toString()), new DatabaseLayer.BinaryOperandField(Fields.KEY_ID, kyberPreKeyId))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void markAllStaleIfNecessary(ServiceId serviceId, long staleTime) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.STALE_TIMESTAMP, staleTime)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ACCOUNT_ID, serviceId.toString()), new DatabaseLayer.BinaryOperandField(Fields.STALE_TIMESTAMP, 0L), new DatabaseLayer.BinaryOperandField(Fields.LAST_RESORT, false))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ACCOUNT_ID(FieldBuilder.newField("account_id", FieldType.SHORT_STRING)),
        KEY_ID(FieldBuilder.newField("key_id", FieldType.INT).withPrimaryKey(true)),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG)),
        LAST_RESORT(FieldBuilder.newField("last_resort", FieldType.BOOLEAN)),
        SERIALIZED(FieldBuilder.newField("serialized", FieldType.BLOB)),
        STALE_TIMESTAMP(FieldBuilder.newField("stale_timestamp", FieldType.LONG).withDefaultValue(0));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return KyberPreKeyData.TABLE_NAME;
        }
    }
}

