/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.keys.IdentityStoreRecord;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.SignalProtocolAddress;

public class IdentityData
extends BaseData<IdentityStoreRecord> {
    private static final Logger LOG = Logger.getLogger(IdentityData.class.getName());
    public static final String TABLE_NAME = "identities";

    public IdentityData(Connection connection) {
        super(connection, TABLE_NAME, List.of(Fields.values()));
    }

    @Override
    public IdentityStoreRecord construct(ResultSet resultSet) throws SQLException {
        byte[] record = (byte[])Fields.IDENTITY_KEY.getValue(resultSet);
        String address = (String)Fields.ADDRESS.getValue(resultSet);
        long timeStamp = (Long)Fields.TIMESTAMP.getValue(resultSet);
        boolean firstUse = (Boolean)Fields.FIRST_USE.getValue(resultSet);
        int verified = (Integer)Fields.VERIFIED.getValue(resultSet);
        boolean nonblockingApproval = (Boolean)Fields.NONBLOCKING_APPROVAL.getValue(resultSet);
        try {
            return new IdentityStoreRecord(address, new IdentityKey(record), verified, firstUse, timeStamp, nonblockingApproval);
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentityStoreRecord findByAddress(SignalProtocolAddress address) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()))).execute();){
            if (!result.next()) return null;
            IdentityStoreRecord identityStoreRecord = this.construct(result);
            return identityStoreRecord;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void add(SignalProtocolAddress address, IdentityKey ik, int verifiedStatus, boolean firstUse, long timestamp, boolean nonblockingApproval) {
        IdentityStoreRecord exists = this.findByAddress(address);
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ADDRESS, address.getName()), Map.entry(Fields.IDENTITY_KEY, ik.serialize()), Map.entry(Fields.TIMESTAMP, timestamp), Map.entry(Fields.VERIFIED, verifiedStatus), Map.entry(Fields.FIRST_USE, firstUse), Map.entry(Fields.NONBLOCKING_APPROVAL, nonblockingApproval));
        try {
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public boolean setApproval(SignalProtocolAddress address, boolean nonBlockingApproval) {
        try {
            return this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.NONBLOCKING_APPROVAL, nonBlockingApproval)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()))).execute() > 0;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void update(SignalProtocolAddress address, IdentityKey ik, int verifiedStatus, boolean firstUse, long timestamp, boolean nonblockingApproval) {
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ADDRESS, address.getName()), Map.entry(Fields.IDENTITY_KEY, ik.serialize()), Map.entry(Fields.TIMESTAMP, timestamp), Map.entry(Fields.VERIFIED, verifiedStatus), Map.entry(Fields.FIRST_USE, firstUse), Map.entry(Fields.NONBLOCKING_APPROVAL, nonblockingApproval));
        List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()));
        try {
            this.databaseLayer.update(this.getTableName()).values(values).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ADDRESS(FieldBuilder.newField("address", FieldType.SHORT_STRING).withPrimaryKey(true)),
        IDENTITY_KEY(FieldBuilder.newField("identityKey", FieldType.BLOB)),
        FIRST_USE(FieldBuilder.newField("first_use", FieldType.BOOLEAN)),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG)),
        VERIFIED(FieldBuilder.newField("verified", FieldType.INT)),
        NONBLOCKING_APPROVAL(FieldBuilder.newField("nonblockingApproval", FieldType.BOOLEAN));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return IdentityData.TABLE_NAME;
        }
    }

    public static enum VerifiedStatus {
        DEFAULT,
        VERIFIED,
        UNVERIFIED;

    }
}

