/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.group;

import com.google.protobuf.ByteString;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.storageservice.protos.groups.GroupInviteLink;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.whispersystems.util.Base64UrlSafe;

public class GroupInviteLinkUrl {
    private static final String GROUP_URL_HOST = "signal.group";
    private static final String GROUP_URL_PREFIX = "https://signal.group/#";
    private final GroupMasterKey masterKey;
    private final ByteString password;
    private final String url;

    private GroupInviteLinkUrl(GroupMasterKey masterKey, ByteString password) {
        this.masterKey = masterKey;
        this.password = password;
        this.url = GroupInviteLinkUrl.createUrl(masterKey, password);
    }

    public static GroupInviteLinkUrl forGroup(GroupMasterKey masterKey, DecryptedGroup groupState) {
        return new GroupInviteLinkUrl(masterKey, groupState.getInviteLinkPassword());
    }

    public String getUrl() {
        return this.url;
    }

    private static String createUrl(GroupMasterKey masterKey, ByteString password) {
        GroupInviteLink groupInviteLink = GroupInviteLink.newBuilder().setV1Contents(GroupInviteLink.GroupInviteLinkContentsV1.newBuilder().setGroupMasterKey(ByteString.copyFrom((byte[])masterKey.serialize())).setInviteLinkPassword(password).build()).build();
        String encoding = Base64UrlSafe.encodeBytesWithoutPadding((byte[])groupInviteLink.toByteArray());
        return GROUP_URL_PREFIX + encoding;
    }
}

