/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.distributionlist;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.distributionlist.CreateDistributionListRequest;
import io.privacyresearch.clientdata.distributionlist.DistributionListDbRecord;
import io.privacyresearch.clientdata.distributionlist.DistributionListKey;
import io.privacyresearch.clientdata.distributionlist.DistributionListMembershipData;
import io.privacyresearch.clientdata.distributionlist.DistributionListMembershipRecord;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class DistributionListData
extends EntityKeyData<DistributionListDbRecord, DistributionListKey> {
    private static final Logger LOG = Logger.getLogger(DistributionListData.class.getName());
    public static final String TABLE_NAME = "distribution_list";
    private final DistributionListMembershipData distributionListMembershipData;
    private final RecipientData recipientData;

    public DistributionListData(Connection connection, RecipientData recipientData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), DistributionListKey::new);
        this.distributionListMembershipData = new DistributionListMembershipData(connection, this, recipientData);
        this.recipientData = recipientData;
    }

    public DistributionListMembershipData getDistributionListMembershipData() {
        return this.distributionListMembershipData;
    }

    @Override
    public void createTable() throws SQLException {
        super.createTable();
        this.distributionListMembershipData.createTable();
    }

    @Override
    public DistributionListDbRecord construct(ResultSet resultSet) throws SQLException {
        Integer recipientId = (Integer)Fields.RECIPIENT_ID.getValue(resultSet);
        RecipientRecord recipient = null;
        if (recipientId != null) {
            recipient = (RecipientRecord)this.recipientData.findById(recipientId);
        }
        DistributionListKey distributionListKey = new DistributionListKey((byte[])Fields.ENTITY_KEY.getValue(resultSet));
        Set<RecipientKey> recipients = this.getRecipients(distributionListKey);
        long deletionTimestamp = (Long)Fields.DELETION_TIMESTAMP.getValue(resultSet);
        if (deletionTimestamp == 0L) {
            return new DistributionListDbRecord(distributionListKey, (String)Fields.DISTRIBUTION_ID.getValue(resultSet), recipient, (String)Fields.NAME.getValue(resultSet), (Boolean)Fields.ALLOW_REPLIES.getValue(resultSet), DistributionListDbRecord.PrivacyMode.fromMode((Integer)Fields.PRIVACY_MODE.getValue(resultSet)), recipients, null);
        }
        return new DistributionListDbRecord(distributionListKey, (String)Fields.DISTRIBUTION_ID.getValue(resultSet), recipient, null, null, null, Set.of(), deletionTimestamp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<DistributionListDbRecord> getByDistributionId(String distributionId) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_ID, distributionId))).execute();){
            if (result.next()) {
                Optional<DistributionListDbRecord> optional2 = Optional.of(this.construct(result));
                return optional2;
            }
            Optional<DistributionListDbRecord> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DistributionListDbRecord getByRecipientKey(RecipientKey recipientKey) {
        try {
            Integer recipientId = (Integer)this.recipientData.getIdByKey(recipientKey);
            if (recipientId == null) {
                return null;
            }
            try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.RECIPIENT_ID, recipientId))).execute();){
                if (result.next()) {
                    DistributionListDbRecord distributionListDbRecord2 = this.construct(result);
                    return distributionListDbRecord2;
                }
                DistributionListDbRecord distributionListDbRecord = null;
                return distributionListDbRecord;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public Set<RecipientKey> getRecipients(DistributionListKey distributionListKey) {
        return this.distributionListMembershipData.listByDistributionList(distributionListKey).stream().map(DistributionListMembershipRecord::recipientKey).collect(Collectors.toSet());
    }

    public boolean addRecipient(DistributionListKey distributionListKey, RecipientKey recipientKey) {
        try {
            Integer distributionListId = (Integer)this.getIdByKey(distributionListKey);
            if (distributionListId == null) {
                throw new IllegalStateException("A distribution list with key " + String.valueOf(distributionListKey) + " should exist!");
            }
            Integer recipientId = (Integer)this.recipientData.getIdByKey(recipientKey);
            if (recipientId == null) {
                throw new IllegalStateException("A recipient with key " + String.valueOf(recipientKey) + " should exist!");
            }
            if (this.membershipExists(distributionListId, recipientId)) {
                return false;
            }
            Map<Field, Object> values = Map.ofEntries(Map.entry(DistributionListMembershipData.Fields.DISTRIBUTION_LIST_ID, distributionListId), Map.entry(DistributionListMembershipData.Fields.RECIPIENT_ID, recipientId));
            this.databaseLayer.insert(this.distributionListMembershipData.getTableName()).values(values).execute();
            return true;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private boolean membershipExists(Integer distributionListId, Integer recipientId) throws SQLException {
        try (ResultSet result = this.databaseLayer.select(List.of(DistributionListMembershipData.Fields.ID)).from(this.distributionListMembershipData.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(DistributionListMembershipData.Fields.DISTRIBUTION_LIST_ID, distributionListId), new DatabaseLayer.BinaryOperandField(DistributionListMembershipData.Fields.RECIPIENT_ID, recipientId))).execute();){
            boolean bl = result.next();
            return bl;
        }
    }

    public DistributionListKey create(Backup.DistributionListItem backup) {
        String distributionId = UuidUtil.fromByteString((ByteString)backup.getDistributionId()).toString();
        if (backup.hasDistributionList()) {
            HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.NAME, backup.getDistributionList().getName()), Map.entry(Fields.ALLOW_REPLIES, backup.getDistributionList().getAllowReplies()), Map.entry(Fields.PRIVACY_MODE, backup.getDistributionList().getPrivacyModeValue())));
            return this.createOrUpdate(distributionId, values);
        }
        HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.DELETION_TIMESTAMP, backup.getDeletionTimestamp())));
        return this.createOrUpdate(distributionId, values);
    }

    public DistributionListKey create(CreateDistributionListRequest request) {
        String distributionId = UUID.randomUUID().toString();
        HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.NAME, request.name()), Map.entry(Fields.ALLOW_REPLIES, request.allowReplies()), Map.entry(Fields.PRIVACY_MODE, request.privacyMode().mode)));
        try {
            DistributionListKey distributionListKey = this.createOrUpdate(distributionId, values);
            Integer distributionListId = (Integer)this.getIdByKey(distributionListKey);
            List<List<DatabaseLayer.InsertableField>> recipientsValues = request.recipients().stream().map(recipientKey -> {
                try {
                    Integer recipientId = (Integer)this.recipientData.getIdByKey(recipientKey);
                    return List.of(new DatabaseLayer.InsertableField(DistributionListMembershipData.Fields.DISTRIBUTION_LIST_ID, distributionListId), new DatabaseLayer.InsertableField(DistributionListMembershipData.Fields.RECIPIENT_ID, recipientId));
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    return List.of();
                }
            }).filter(v -> !v.isEmpty()).collect(Collectors.toList());
            if (!recipientsValues.isEmpty()) {
                this.databaseLayer.insert(this.distributionListMembershipData.getTableName()).bulkValues(recipientsValues).execute();
            }
            return distributionListKey;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private DistributionListKey createOrUpdate(String distributionId, Map<Field, Object> values) {
        try {
            Optional<DistributionListDbRecord> exists = this.getByDistributionId(distributionId);
            if (exists.isPresent()) {
                this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, exists.get().key().getKey()))).execute();
                return exists.get().key();
            }
            DistributionListKey distributionListKey = new DistributionListKey();
            RecipientKey recipientKey = this.recipientData.createDistributionListRecipient(distributionListKey);
            values.put(Fields.ENTITY_KEY, distributionListKey.getKey());
            values.put(Fields.RECIPIENT_ID, this.recipientData.getIdByKey(recipientKey));
            values.put(Fields.DISTRIBUTION_ID, distributionId);
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
            return distributionListKey;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        RECIPIENT_ID(FieldBuilder.newField("recipient_id", FieldType.INT).withNullable(false).withUnique(true).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        DISTRIBUTION_ID(FieldBuilder.newField("distribution_id", FieldType.TEXT).withUnique(true).withDefaultNull()),
        NAME(FieldBuilder.newField("name", FieldType.TEXT).withDefaultNull()),
        ALLOW_REPLIES(FieldBuilder.newField("allow_replies", FieldType.BOOLEAN).withDefaultNull()),
        PRIVACY_MODE(FieldBuilder.newField("privacy_mode", FieldType.INT).withDefaultValue(DistributionListDbRecord.PrivacyMode.UNKNOWN.mode)),
        DELETION_TIMESTAMP(FieldBuilder.newField("deletion_timestamp", FieldType.LONG).withDefaultValue(0));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return DistributionListData.TABLE_NAME;
        }
    }
}

