/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.attachment;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.internal.push.SignalServiceProtos;
import org.whispersystems.util.FlagUtil;

public class AttachmentData
extends EntityKeyData<AttachmentRecord, AttachmentKey> {
    private static final Logger LOG = Logger.getLogger(AttachmentData.class.getName());
    public static final String TABLE_NAME = "attachment";
    private final MessageData messageData;

    public AttachmentData(Connection connection, MessageData messageData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), AttachmentKey::new);
        this.messageData = messageData;
    }

    @Override
    public AttachmentRecord construct(ResultSet resultSet) throws SQLException {
        MessageKey messageKey = (MessageKey)this.messageData.getKeyById(Fields.MESSAGE_ID.getValue(resultSet));
        return new AttachmentRecord(new AttachmentKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), messageKey, (byte[])Fields.KEY.getValue(resultSet), (String)Fields.CONTENT_TYPE.getValue(resultSet), (Integer)Fields.SIZE.getValue(resultSet), (Integer)Fields.ENCRYPTED_SIZE.getValue(resultSet), (byte[])Fields.DIGEST.getValue(resultSet), (byte[])Fields.INCREMENTAL_MAC.getValue(resultSet), (Integer)Fields.INCREMENTAL_MAC_CHUNK_SIZE.getValue(resultSet), (String)Fields.FILE_NAME.getValue(resultSet), (Integer)Fields.FLAGS.getValue(resultSet), (Integer)Fields.WIDTH.getValue(resultSet), (Integer)Fields.HEIGHT.getValue(resultSet), (String)Fields.CAPTION.getValue(resultSet), (String)Fields.BLUR_HASH.getValue(resultSet), new AttachmentRecord.RemoteId((byte[])Fields.CDN_KEY.getValue(resultSet)), (Integer)Fields.CDN_NUMBER.getValue(resultSet), (Long)Fields.UPLOAD_TIMESTAMP.getValue(resultSet), (String)Fields.LOCATION.getValue(resultSet));
    }

    public AttachmentKey addAttachment(MessageKey messageKey, SignalServiceAttachmentPointer attachmentPointer, String attachmentLocation) {
        return this.addAttachment(messageKey, attachmentPointer, attachmentLocation, -1);
    }

    public AttachmentKey addAttachment(MessageKey messageKey, SignalServiceAttachmentPointer attachmentPointer, String attachmentLocation, int encryptedSize) {
        try {
            Integer messageId = (Integer)this.messageData.getIdByKey(messageKey);
            if (messageId == null) {
                throw new IllegalStateException("A message with key " + String.valueOf(messageKey) + " should exist!");
            }
            int flags = 0;
            if (attachmentPointer.getVoiceNote()) {
                flags |= FlagUtil.toBinaryFlag((int)SignalServiceProtos.AttachmentPointer.Flags.VOICE_MESSAGE.getNumber());
            }
            if (attachmentPointer.isBorderless()) {
                flags |= FlagUtil.toBinaryFlag((int)SignalServiceProtos.AttachmentPointer.Flags.BORDERLESS.getNumber());
            }
            if (attachmentPointer.isGif()) {
                flags |= FlagUtil.toBinaryFlag((int)SignalServiceProtos.AttachmentPointer.Flags.GIF.getNumber());
            }
            byte[] cdnKey = null;
            if (attachmentPointer.getRemoteId().getV2().isPresent()) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putLong((Long)attachmentPointer.getRemoteId().getV2().get());
                cdnKey = buffer.array();
            } else {
                cdnKey = ((String)attachmentPointer.getRemoteId().getV3().get()).getBytes(StandardCharsets.UTF_8);
            }
            AttachmentKey attachmentKey = new AttachmentKey();
            HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.ENTITY_KEY, attachmentKey.getKey()), Map.entry(Fields.MESSAGE_ID, messageId), Map.entry(Fields.KEY, attachmentPointer.getKey()), Map.entry(Fields.CONTENT_TYPE, attachmentPointer.getContentType()), Map.entry(Fields.FLAGS, flags), Map.entry(Fields.WIDTH, attachmentPointer.getWidth()), Map.entry(Fields.HEIGHT, attachmentPointer.getHeight()), Map.entry(Fields.CDN_KEY, cdnKey), Map.entry(Fields.CDN_NUMBER, attachmentPointer.getCdnNumber()), Map.entry(Fields.UPLOAD_TIMESTAMP, attachmentPointer.getUploadTimestamp()), Map.entry(Fields.LOCATION, attachmentLocation), Map.entry(Fields.ENCRYPTED_SIZE, encryptedSize)));
            attachmentPointer.getSize().ifPresent(size -> values.put(Fields.SIZE, size));
            attachmentPointer.getDigest().ifPresent(digest -> values.put(Fields.DIGEST, digest));
            attachmentPointer.getIncrementalDigest().ifPresent(incrementalDigest -> {
                values.put(Fields.INCREMENTAL_MAC, incrementalDigest);
                values.put(Fields.INCREMENTAL_MAC_CHUNK_SIZE, attachmentPointer.getIncrementalMacChunkSize());
            });
            attachmentPointer.getFileName().ifPresent(fileName -> values.put(Fields.FILE_NAME, fileName));
            attachmentPointer.getCaption().ifPresent(caption -> values.put(Fields.CAPTION, caption));
            attachmentPointer.getBlurHash().ifPresent(blurHash -> values.put(Fields.BLUR_HASH, blurHash));
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return attachmentKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void setEncryptedSize(AttachmentKey attachmentKey, int size) {
        LOG.info("Set encrypted size for " + String.valueOf(attachmentKey) + " to " + size);
        try {
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENCRYPTED_SIZE, size);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, attachmentKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<AttachmentRecord> findByMessageKey(MessageKey messageKey) {
        LinkedList<AttachmentRecord> linkedList;
        block10: {
            Integer messageId = (Integer)this.messageData.getIdByKey(messageKey);
            if (messageId == null) {
                return new LinkedList<AttachmentRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.MESSAGE_ID, messageId))).execute();
            try {
                LinkedList<AttachmentRecord> attachments = new LinkedList<AttachmentRecord>();
                while (result.next()) {
                    attachments.add(this.construct(result));
                }
                linkedList = attachments;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return linkedList;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        MESSAGE_ID(FieldBuilder.newField("message_id", FieldType.INT).withNullable(false).withReference("message", MessageData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        KEY(FieldBuilder.newField("key", FieldType.BLOB)),
        CONTENT_TYPE(FieldBuilder.newField("content_type", FieldType.TEXT)),
        SIZE(FieldBuilder.newField("size", FieldType.INT)),
        ENCRYPTED_SIZE(FieldBuilder.newField("encrypted_size", FieldType.INT).withDefaultValue(-1)),
        DIGEST(FieldBuilder.newField("digest", FieldType.BLOB)),
        INCREMENTAL_MAC(FieldBuilder.newField("incremental_mac", FieldType.BLOB)),
        INCREMENTAL_MAC_CHUNK_SIZE(FieldBuilder.newField("incremental_mac_chunk_size", FieldType.INT)),
        FILE_NAME(FieldBuilder.newField("file_name", FieldType.TEXT)),
        FLAGS(FieldBuilder.newField("flags", FieldType.INT)),
        WIDTH(FieldBuilder.newField("width", FieldType.INT)),
        HEIGHT(FieldBuilder.newField("height", FieldType.INT)),
        CAPTION(FieldBuilder.newField("caption", FieldType.TEXT)),
        BLUR_HASH(FieldBuilder.newField("blur_hash", FieldType.TEXT)),
        CDN_KEY(FieldBuilder.newField("cdn_key", FieldType.BLOB)),
        CDN_NUMBER(FieldBuilder.newField("cdn_number", FieldType.INT)),
        UPLOAD_TIMESTAMP(FieldBuilder.newField("upload_timestamp", FieldType.LONG)),
        LOCATION(FieldBuilder.newField("location", FieldType.TEXT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return AttachmentData.TABLE_NAME;
        }
    }
}

