/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.views;

import com.airhacks.afterburner.injection.Injector;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;

public abstract class FXMLView {
    public static final String DEFAULT_ENDING = "view";
    protected ObjectProperty<Object> presenterProperty;
    protected FXMLLoader fxmlLoader;
    protected String bundleName;
    protected ResourceBundle bundle;
    protected final Function<String, Object> injectionContext;
    protected URL resource;
    protected static final Executor PARENT_CREATION_POOL = Executors.newCachedThreadPool(runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setDaemon(true);
        return thread;
    });

    public FXMLView() {
        this(f -> null);
    }

    public FXMLView(Function<String, Object> injectionContext) {
        this.injectionContext = injectionContext;
        this.init(this.getClass(), this.getFXMLName());
    }

    private void init(Class<?> clazz, String conventionalName) {
        this.presenterProperty = new SimpleObjectProperty();
        this.resource = clazz.getResource(conventionalName);
        this.bundleName = this.getBundleName();
        this.bundle = FXMLView.getResourceBundle(this.bundleName);
    }

    FXMLLoader loadSynchronously(URL resource, ResourceBundle bundle, String conventionalName) throws IllegalStateException {
        FXMLLoader loader = new FXMLLoader(resource, bundle);
        loader.setControllerFactory(p -> Injector.instantiatePresenter(p, this.injectionContext));
        try {
            loader.load();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot load " + conventionalName, ex);
        }
        return loader;
    }

    void initializeFXMLLoader() {
        if (this.fxmlLoader == null) {
            this.fxmlLoader = this.loadSynchronously(this.resource, this.bundle, this.bundleName);
            this.presenterProperty.set(this.fxmlLoader.getController());
        }
    }

    public Parent getView() {
        this.initializeFXMLLoader();
        Parent parent = (Parent)this.fxmlLoader.getRoot();
        this.addCSSIfAvailable(parent);
        return parent;
    }

    public void getView(Consumer<Parent> consumer) {
        Supplier<Parent> supplier = this::getView;
        Executor fxExecutor = Platform::runLater;
        CompletableFuture.supplyAsync(supplier, fxExecutor).thenAccept((Consumer)consumer);
    }

    public void getViewAsync(Consumer<Parent> consumer) {
        PARENT_CREATION_POOL.execute(() -> this.getView(consumer));
    }

    public Node getViewWithoutRootContainer() {
        ObservableList children = this.getView().getChildrenUnmodifiable();
        if (children.isEmpty()) {
            return null;
        }
        return (Node)children.listIterator().next();
    }

    void addCSSIfAvailable(Parent parent) {
        URL uri = this.getClass().getResource(this.getStyleSheetName());
        if (uri == null) {
            return;
        }
        String uriToCss = uri.toExternalForm();
        parent.getStylesheets().add((Object)uriToCss);
    }

    String getStyleSheetName() {
        return this.getConventionalName(".css");
    }

    public Object getPresenter() {
        this.initializeFXMLLoader();
        return this.presenterProperty.get();
    }

    public void getPresenter(Consumer<Object> presenterConsumer) {
        this.presenterProperty.addListener((o, oldValue, newValue) -> presenterConsumer.accept(newValue));
    }

    protected String getConventionalName(String ending) {
        return this.getConventionalName() + ending;
    }

    protected String getConventionalName() {
        String clazz = this.getClass().getSimpleName().toLowerCase();
        return FXMLView.stripEnding(clazz);
    }

    String getBundleName() {
        String conventionalName = this.getConventionalName();
        return this.getClass().getPackage().getName() + "." + conventionalName;
    }

    static String stripEnding(String clazz) {
        if (!clazz.endsWith(DEFAULT_ENDING)) {
            return clazz;
        }
        int viewIndex = clazz.lastIndexOf(DEFAULT_ENDING);
        return clazz.substring(0, viewIndex);
    }

    final String getFXMLName() {
        return this.getConventionalName(".fxml");
    }

    public static ResourceBundle getResourceBundle(String name) {
        try {
            return ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }
}

